/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MakeIndicator;

public class MakeIndicatorTest
extends AbstractFilterTest {
    public MakeIndicatorTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        MakeIndicator f = new MakeIndicator();
        f.setAttributeIndex("2");
        return f;
    }

    public void testInvalidAttributeTypes() {
        Instances icopy = new Instances(this.m_Instances);
        try {
            ((MakeIndicator)this.m_Filter).setAttributeIndex("1");
            this.m_Filter.setInputFormat(icopy);
            MakeIndicatorTest.fail("Should have thrown an exception selecting a STRING attribute!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((MakeIndicator)this.m_Filter).setAttributeIndex("3");
            this.m_Filter.setInputFormat(icopy);
            MakeIndicatorTest.fail("Should have thrown an exception indicating a NUMERIC attribute!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testDefault() {
        ((MakeIndicator)this.m_Filter).setAttributeIndex("2");
        Instances result = this.useFilter();
        MakeIndicatorTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        MakeIndicatorTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        MakeIndicatorTest.assertEquals("Default attribute encoding should be NUMERIC", 0, result.attribute(1).type());
        int i = 0;
        while (i < result.numInstances()) {
            MakeIndicatorTest.assertTrue("Checking indicator for instance: " + (i + 1), this.m_Instances.instance(i).value(1) == 2.0 == (result.instance(i).value(1) == 1.0));
            ++i;
        }
    }

    public void testNominalEncoding() {
        ((MakeIndicator)this.m_Filter).setAttributeIndex("2");
        ((MakeIndicator)this.m_Filter).setNumeric(false);
        Instances result = this.useFilter();
        MakeIndicatorTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        MakeIndicatorTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        MakeIndicatorTest.assertEquals("New attribute encoding should be NOMINAL", 1, result.attribute(1).type());
        int i = 0;
        while (i < result.numInstances()) {
            MakeIndicatorTest.assertTrue("Checking indicator for instance: " + (i + 1), this.m_Instances.instance(i).value(1) == 2.0 == (result.instance(i).value(1) == 1.0));
            ++i;
        }
    }

    public void testMultiValueIndication() {
        ((MakeIndicator)this.m_Filter).setAttributeIndex("2");
        try {
            ((MakeIndicator)this.m_Filter).setValueIndices("1,3");
        }
        catch (Exception ex) {
            MakeIndicatorTest.fail("Is Range broken?");
        }
        ((MakeIndicator)this.m_Filter).setNumeric(false);
        Instances result = this.useFilter();
        MakeIndicatorTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        MakeIndicatorTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        MakeIndicatorTest.assertEquals("New attribute encoding should be NOMINAL", 1, result.attribute(1).type());
        int i = 0;
        while (i < result.numInstances()) {
            MakeIndicatorTest.assertTrue("Checking indicator for instance: " + (i + 1), (this.m_Instances.instance(i).value(1) == 0.0 || this.m_Instances.instance(i).value(1) == 2.0) == (result.instance(i).value(1) == 1.0));
            ++i;
        }
    }

    @Override
    public void testFilteredClassifier() {
        try {
            Instances data = this.getFilteredClassifierData();
            int i = 0;
            while (i < data.numAttributes()) {
                if (data.classIndex() != i && data.attribute(i).isNominal()) {
                    ((MakeIndicator)this.m_FilteredClassifier.getFilter()).setAttributeIndex("" + (i + 1));
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            MakeIndicatorTest.fail("Problem setting up test for FilteredClassifier: " + e.toString());
        }
        super.testFilteredClassifier();
    }

    public static Test suite() {
        return new TestSuite(MakeIndicatorTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(MakeIndicatorTest.suite());
    }
}

